/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.client.color.IBlockInformationColorManager;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.client.model.baked.face.model.ModelQuadLayer;
import mod.chiselsandbits.client.model.baked.face.model.ModelVertexRange;
import mod.chiselsandbits.client.model.baked.simple.SimpleGeneratedModel;
import mod.chiselsandbits.platforms.core.client.rendering.IRenderingManager;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.fluid.IFluidManager;
import mod.chiselsandbits.platforms.core.registries.IPlatformRegistryManager;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.LightUtil;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_777;
import net.minecraft.class_806;

public final class FaceManager {
    private static final Random RANDOM = new Random();
    private static final FaceManager INSTANCE = new FaceManager();
    private final SimpleMaxSizedCache<Key, ModelQuadLayer[]> cache = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getFaceLayerCacheSize())::get);
    private final SimpleMaxSizedCache<BlockInformation, Integer> colorCache = new SimpleMaxSizedCache(() -> IPlatformRegistryManager.getInstance().getBlockStateIdMap().method_10204() == 0 ? 1000 : IPlatformRegistryManager.getInstance().getBlockStateIdMap().method_10204());

    private FaceManager() {
    }

    public static FaceManager getInstance() {
        return INSTANCE;
    }

    public void clearCache() {
        this.cache.clear();
        this.colorCache.clear();
    }

    public ModelQuadLayer[] getCachedFace(BlockInformation state, class_2350 face, class_1921 layer, long primaryStateRenderSeed) {
        if (layer == null) {
            return null;
        }
        Key key = new Key(state, layer, face, primaryStateRenderSeed);
        return this.cache.get(key, () -> {
            Optional<class_1921> original = IRenderTypeManager.getInstance().getCurrentRenderType();
            try {
                IRenderTypeManager.getInstance().setCurrentRenderType(layer);
                ModelQuadLayer[] modelQuadLayerArray = this.buildFaceQuadLayers(state, face, primaryStateRenderSeed);
                return modelQuadLayerArray;
            }
            finally {
                IRenderTypeManager.getInstance().setCurrentRenderType(original.orElse(null));
            }
        });
    }

    private ModelQuadLayer[] buildFaceQuadLayers(BlockInformation state, class_2350 face, long primaryStateRenderSeed) {
        class_1087 model = FaceManager.solveModel(state, class_310.method_1551().method_1541().method_3351().method_3335(state.getBlockState()), primaryStateRenderSeed);
        int lv = IClientConfiguration.getInstance().getUseGetLightValue().get() != false ? state.getBlockState().method_26213() : 0;
        class_3611 fluid = state.getBlockState().method_26227().method_15772();
        if (fluid != class_3612.field_15906) {
            ModelQuadLayer[] mp = new ModelQuadLayer[]{new ModelQuadLayer()};
            mp[0].setColor(IFluidManager.getInstance().getFluidColor(new FluidInformation(fluid)));
            mp[0].setLight(lv);
            float V = 0.5f;
            float Uf = 1.0f;
            float U = 0.5f;
            float Vf = 1.0f;
            if (face.method_10166() == class_2350.class_2351.field_11052) {
                mp[0].setSprite((class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(IRenderingManager.getInstance().getStillFluidTexture(fluid)));
                mp[0].setUvs(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f});
            } else if (face.method_10166() == class_2350.class_2351.field_11048) {
                mp[0].setSprite((class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(IRenderingManager.getInstance().getFlowingFluidTexture(fluid)));
                mp[0].setUvs(new float[]{0.5f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f});
            } else {
                mp[0].setSprite((class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(IRenderingManager.getInstance().getFlowingFluidTexture(fluid)));
                mp[0].setUvs(new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.5f});
            }
            mp[0].setTint(0);
            return mp;
        }
        ArrayList layers = Lists.newArrayList();
        int color = this.getColorFor(state);
        if (model != null) {
            List<class_777> quads = FaceManager.getModelQuads(model, state, face, primaryStateRenderSeed);
            FaceManager.processFaces(layers, face, quads);
        }
        ModelQuadLayer[] quadLayers = new ModelQuadLayer[layers.size()];
        for (int layerIndex = 0; layerIndex < layers.size(); ++layerIndex) {
            quadLayers[layerIndex] = ((ModelQuadLayer.ModelQuadLayerBuilder)layers.get(layerIndex)).build(state, color, lv);
        }
        return quadLayers;
    }

    private static void processFaces(List<ModelQuadLayer.ModelQuadLayerBuilder> layers, class_2350 face, List<class_777> quads) {
        for (class_777 quad : quads) {
            if (quad.method_3358() != face) {
                return;
            }
            try {
                class_1058 sprite = FaceManager.findQuadTexture(quad);
                ModelQuadLayer.ModelQuadLayerBuilder layerBuilder = null;
                for (ModelQuadLayer.ModelQuadLayerBuilder builder : layers) {
                    if (builder.getCache().getSprite() != sprite) continue;
                    layerBuilder = builder;
                    break;
                }
                if (layerBuilder == null) {
                    int uCoord = 0;
                    int vCoord = 2;
                    switch (face) {
                        case field_11043: 
                        case field_11035: {
                            vCoord = 1;
                            break;
                        }
                        case field_11034: 
                        case field_11039: {
                            uCoord = 1;
                            break;
                        }
                    }
                    layerBuilder = new ModelQuadLayer.ModelQuadLayerBuilder(sprite, uCoord, vCoord);
                    layerBuilder.getCache().setTint(quad.method_3359());
                    layers.add(layerBuilder);
                }
                LightUtil.put(layerBuilder.getUvExtractor(), quad);
                if (!IClientConfiguration.getInstance().getEnableFaceLightmapExtraction().get().booleanValue()) continue;
                layerBuilder.getLightValueExtractor().setVertexFormat(class_290.field_1590);
                LightUtil.put(layerBuilder.getLightValueExtractor(), quad);
            }
            catch (Exception exception) {}
        }
    }

    private static class_1087 solveModel(BlockInformation state, class_1087 originalModel, long primaryStateRenderSeed) {
        class_1799 is;
        boolean hasFaces;
        try {
            hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed);
            for (class_2350 f : class_2350.values()) {
                hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed);
            }
        }
        catch (Exception e) {
            hasFaces = false;
        }
        if (!hasFaces && !(is = ItemStackUtils.getItemStackFromBlockState(state)).method_7960()) {
            class_1087 itemModel = class_310.method_1551().method_1480().method_4019(is, (class_1937)class_310.method_1551().field_1687, (class_1309)class_310.method_1551().field_1724, 0);
            try {
                hasFaces = FaceManager.hasFaces(originalModel, state, null, primaryStateRenderSeed);
                for (class_2350 f : class_2350.values()) {
                    hasFaces = hasFaces || FaceManager.hasFaces(originalModel, state, f, primaryStateRenderSeed);
                }
            }
            catch (Exception e) {
                hasFaces = false;
            }
            if (hasFaces) {
                return itemModel;
            }
            return new SimpleGeneratedModel(FaceManager.findTexture(state, originalModel, class_2350.field_11036, primaryStateRenderSeed));
        }
        return originalModel;
    }

    private static boolean hasFaces(class_1087 model, BlockInformation state, class_2350 f, long primaryStateRenderSeed) {
        List<class_777> quads = FaceManager.getModelQuads(model, state, f, primaryStateRenderSeed);
        if (quads == null || quads.isEmpty()) {
            return false;
        }
        class_1058 texture = null;
        try {
            texture = FaceManager.findTexture(null, quads, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModelVertexRange vertexRangeExtractor = new ModelVertexRange();
        for (class_777 quad : quads) {
            LightUtil.put(vertexRangeExtractor, quad);
        }
        return vertexRangeExtractor.getLargestRange() > 0.0f && !FaceManager.isMissingTexture(texture);
    }

    public static class_1058 findTexture(BlockInformation state, class_1087 model, class_2350 myFace, long primaryStateRenderSeed) {
        class_1058 texture = null;
        if (model != null) {
            try {
                texture = FaceManager.findTexture(null, FaceManager.getModelQuads(model, state, myFace, primaryStateRenderSeed), myFace);
                if (texture == null) {
                    for (class_2350 side : class_2350.values()) {
                        texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, side, primaryStateRenderSeed), side);
                    }
                    texture = FaceManager.findTexture(texture, FaceManager.getModelQuads(model, state, null, primaryStateRenderSeed), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                if (model != null) {
                    texture = model.method_4711();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (FaceManager.isMissingTexture(texture)) {
            try {
                texture = class_310.method_1551().method_1541().method_3351().method_3339(state.getBlockState());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            texture = (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(new class_2960("missingno"));
        }
        return texture;
    }

    private static class_1058 findTexture(class_1058 texture, List<class_777> faceQuads, class_2350 myFace) throws IllegalArgumentException, NullPointerException {
        for (class_777 q : faceQuads) {
            if (q.method_3358() != myFace) continue;
            texture = FaceManager.findQuadTexture(q);
        }
        return texture;
    }

    private static class_1058 findQuadTexture(class_777 q) throws IllegalArgumentException, NullPointerException {
        if (q.method_35788() == null) {
            return (class_1058)class_310.method_1551().method_1549(class_1723.field_21668).apply(class_1047.method_4539());
        }
        return q.method_35788();
    }

    private static boolean isMissingTexture(class_1058 sprite) {
        if (sprite == null) {
            return true;
        }
        return sprite.method_4598().equals((Object)class_1047.method_4539());
    }

    private static List<class_777> getModelQuads(class_1087 model, BlockInformation state, class_2350 f, long primaryStateRenderSeed) {
        try {
            RANDOM.setSeed(primaryStateRenderSeed);
            return model.method_4707(state.getBlockState(), f, RANDOM);
        }
        catch (Throwable throwable) {
            try {
                return model.method_4707(null, f, RANDOM);
            }
            catch (Throwable throwable2) {
                class_1087 secondModel;
                class_1799 is = ItemStackUtils.getItemStackFromBlockState(state);
                if (!is.method_7960() && (secondModel = FaceManager.getOverrides(model).method_3495(model, is, class_310.method_1551().field_1687, (class_1309)class_310.method_1551().field_1724, 0)) != null) {
                    try {
                        return secondModel.method_4707(null, f, RANDOM);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                return Collections.emptyList();
            }
        }
    }

    private static class_806 getOverrides(class_1087 model) {
        if (model != null) {
            return model.method_4710();
        }
        return class_806.field_4292;
    }

    private int getColorFor(BlockInformation state) {
        return this.colorCache.get(state, () -> {
            class_1799 target;
            Optional<Integer> dynamicColor = IBlockInformationColorManager.getInstance().getColor(state);
            if (dynamicColor.isPresent()) {
                return dynamicColor.get();
            }
            class_3611 fluid = state.getBlockState().method_26227().method_15772();
            int out = fluid != class_3612.field_15906 ? IFluidManager.getInstance().getFluidColor(fluid) : ((target = ItemStackUtils.getItemStackFromBlockState(state)).method_7960() ? 0xFFFFFF : class_310.method_1551().field_1760.method_1704(target, 0));
            return out;
        });
    }

    private record Key(BlockInformation blockState, class_1921 renderType, class_2350 direction, long primaryStateSeed) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            if (this.primaryStateSeed != key.primaryStateSeed) {
                return false;
            }
            if (!Objects.equals(this.blockState, key.blockState)) {
                return false;
            }
            if (!Objects.equals(this.renderType, key.renderType)) {
                return false;
            }
            return this.direction == key.direction;
        }

        @Override
        public int hashCode() {
            int result = this.blockState != null ? this.blockState.hashCode() : 0;
            result = 31 * result + (this.renderType != null ? this.renderType.hashCode() : 0);
            result = 31 * result + (this.direction != null ? this.direction.hashCode() : 0);
            result = 31 * result + (int)(this.primaryStateSeed ^ this.primaryStateSeed >>> 32);
            return result;
        }
    }
}

